/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.item.curio;

import elucent.eidolon.Registry;
import elucent.eidolon.item.ItemBase;
import elucent.eidolon.item.curio.EidolonCurio;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class MindShieldingPlateItem
extends ItemBase {
    public MindShieldingPlateItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(MindShieldingPlateItem::onPotion);
        MinecraftForge.EVENT_BUS.addListener(MindShieldingPlateItem::onClone);
    }

    @SubscribeEvent
    public static void onPotion(PotionEvent.PotionApplicableEvent event) {
        if (event.getPotionEffect().func_188419_a() == Effects.field_76431_k && CuriosApi.getCuriosHelper().findEquippedCurio((Item)Registry.MIND_SHIELDING_PLATE.get(), event.getEntityLiving()).isPresent()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.getOriginal().field_71068_ca > 0 && CuriosApi.getCuriosHelper().findEquippedCurio((Item)Registry.MIND_SHIELDING_PLATE.get(), event.getEntityLiving()).isPresent()) {
            event.getPlayer().field_71068_ca = event.getOriginal().field_71068_ca * 3 / 4;
            event.getPlayer().field_71106_cc = event.getOriginal().field_71106_cc * 3.0f / 4.0f;
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT unused) {
        return new EidolonCurio(stack){

            public boolean canRightClickEquip() {
                return true;
            }
        };
    }
}

