/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.ritual;

import elucent.eidolon.ritual.IRequirement;
import elucent.eidolon.ritual.RequirementInfo;
import elucent.eidolon.util.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;

public abstract class Ritual {
    ResourceLocation name = null;
    int color;
    ResourceLocation symbol;
    List<IRequirement> stepRequirements = new ArrayList<IRequirement>();
    List<IRequirement> continuousRequirements = new ArrayList<IRequirement>();

    public Ritual(ResourceLocation symbol, float r, float g, float b) {
        this.symbol = symbol;
        this.color = ColorUtil.packColor(255, (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public Ritual(ResourceLocation symbol, int color) {
        this.symbol = symbol;
        this.color = color;
    }

    public ResourceLocation getSymbol() {
        return this.symbol;
    }

    public Ritual setRegistryName(String domain, String path) {
        this.name = new ResourceLocation(domain, path);
        return this;
    }

    public Ritual setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Ritual addRequirement(IRequirement requirement) {
        this.stepRequirements.add(requirement);
        return this;
    }

    public Ritual addInvariant(IRequirement requirement) {
        this.continuousRequirements.add(requirement);
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public float getRed() {
        return (float)ColorUtil.getRed(this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)ColorUtil.getGreen(this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)ColorUtil.getBlue(this.color) / 255.0f;
    }

    public List<IRequirement> getRequirements() {
        return this.stepRequirements;
    }

    public SetupResult setup(World world, BlockPos pos, int step) {
        if (step >= this.stepRequirements.size()) {
            return SetupResult.SUCCEED;
        }
        for (IRequirement req : this.continuousRequirements) {
            RequirementInfo info = req.isMet(this, world, pos);
            if (!info.isMet()) {
                return SetupResult.FAIL;
            }
            req.whenMet(this, world, pos, info);
        }
        IRequirement req = this.stepRequirements.get(step);
        RequirementInfo info = req.isMet(this, world, pos);
        if (!info.isMet()) {
            return SetupResult.FAIL;
        }
        req.whenMet(this, world, pos, info);
        return SetupResult.PASS;
    }

    public AxisAlignedBB getSearchBounds(BlockPos pos) {
        return Ritual.getDefaultBounds(pos);
    }

    public static AxisAlignedBB getDefaultBounds(BlockPos pos) {
        return new AxisAlignedBB((double)(pos.func_177958_n() - 8), (double)(pos.func_177956_o() - 6), (double)(pos.func_177952_p() - 8), (double)(pos.func_177958_n() + 9), (double)(pos.func_177956_o() + 11), (double)(pos.func_177952_p() + 9));
    }

    public RitualResult tick(World world, BlockPos pos) {
        return RitualResult.PASS;
    }

    public RitualResult start(World world, BlockPos pos) {
        return RitualResult.PASS;
    }

    public static <T> List<T> getTilesWithinAABB(Class<T> type, World world, AxisAlignedBB bb) {
        ArrayList<TileEntity> tileList = new ArrayList<TileEntity>();
        for (int i = (int)Math.floor(bb.field_72340_a); i < (int)Math.ceil(bb.field_72336_d) + 16; i += 16) {
            for (int j = (int)Math.floor(bb.field_72339_c); j < (int)Math.ceil(bb.field_72334_f) + 16; j += 16) {
                IChunk c = world.func_217349_x(new BlockPos(i, 0, j));
                Set tiles = c.func_203066_o();
                for (BlockPos p : tiles) {
                    TileEntity t;
                    if (!bb.func_197744_e((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5) || !type.isInstance(t = world.func_175625_s(p))) continue;
                    tileList.add(t);
                }
            }
        }
        return tileList;
    }

    public static enum RitualResult {
        PASS,
        TERMINATE;

    }

    public static enum SetupResult {
        FAIL,
        PASS,
        SUCCEED;

    }
}

