/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.spell;

import elucent.eidolon.spell.AltarInfo;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;

public class AltarEntry {
    double capacity = 0.0;
    double power = 0.0;
    ResourceLocation key = null;
    Consumer<AltarInfo> callback = null;

    AltarEntry(ResourceLocation key) {
        this.key = key;
    }

    AltarEntry setCapacity(double capacity) {
        this.capacity = capacity;
        return this;
    }

    AltarEntry setPower(double power) {
        this.power = power;
        return this;
    }

    AltarEntry setCallback(Consumer<AltarInfo> callback) {
        this.callback = callback;
        return this;
    }

    AltarEntry setKey(ResourceLocation key) {
        this.key = key;
        return this;
    }

    void apply(AltarInfo info) {
        info.attributes.computeIfAbsent(this.key, k -> new AltarInfo.AltarAttributes());
        if (this.capacity > 0.0) {
            info.increaseCapacity(this.key, this.capacity);
        }
        if (this.power > 0.0) {
            info.increasePower(this.key, this.power);
        }
        if (this.callback != null) {
            this.callback.accept(info);
        }
    }
}

