/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.world;

import com.mojang.serialization.Codec;
import elucent.eidolon.Config;
import elucent.eidolon.WorldGen;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class LabStructure
extends Structure<NoFeatureConfig> {
    private static final ResourceLocation PART = new ResourceLocation("eidolon", "lab");

    public LabStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, NoFeatureConfig config) {
        int i = chunkX >> 4;
        int j = chunkZ >> 4;
        rand.setSeed((long)(i ^ j << 4) ^ seed);
        double prob = (float)rand.nextInt(10000) / 10000.0f;
        return prob < 1.0 / (Double)Config.LAB_RARITY.get();
    }

    public String func_143025_a() {
        return new ResourceLocation("eidolon", "lab").toString();
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation loc;
        private Rotation rotation;

        public Piece(IStructurePieceType structurePieceTypeIn, CompoundNBT nbt) {
            super(structurePieceTypeIn, nbt);
            this.loc = new ResourceLocation(nbt.func_74779_i("template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("rot"));
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            this(WorldGen.LAB_PIECE, nbt);
            Template part = templateManager.func_200220_a(PART);
            PlacementSettings placement = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(part, this.field_186178_c, placement);
            this.field_186176_a = templateManager.func_200219_b(PART);
        }

        public Piece(TemplateManager templateManager, ResourceLocation template, BlockPos pos, Rotation rot, Random random) {
            super(WorldGen.LAB_PIECE, 0);
            this.field_186178_c = pos;
            this.rotation = rot;
            this.loc = template;
            Template part = templateManager.func_200220_a(PART);
            PlacementSettings placement = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(part, this.field_186178_c, placement);
            this.field_186176_a = templateManager.func_200219_b(PART);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("template", this.loc.toString());
            tagCompound.func_74778_a("rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        }
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> config, int chunkX, int chunkZ, MutableBoundingBox bounds, int refs, long seed) {
            super(config, chunkX, chunkZ, bounds, refs, seed);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int i = chunkX * 16;
            int j = chunkZ * 16;
            int k = Math.min(generator.func_230356_f_(), generator.func_222532_b(i, j, Heightmap.Type.OCEAN_FLOOR_WG));
            if (k < 33) {
                k = 33;
            }
            BlockPos blockpos = new BlockPos(i + this.field_214631_d.nextInt(16), this.field_214631_d.nextInt(k - 32) + 8, j + this.field_214631_d.nextInt(16));
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            this.field_75075_a.add(new Piece(templateManager, PART, blockpos, rotation, (Random)this.field_214631_d));
            this.func_202500_a();
        }
    }
}

