/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;

public class MaximumBlockCountValidator
implements IBlockCountValidator {
    private final int maximumCount;

    @Override
    public ITextComponent isValid(int count, boolean structureComplete, Block block) {
        if (count <= this.getMaximumCount()) {
            return null;
        }
        return new TranslationTextComponent("multiblock.cyclopscore.error.blockCount.max", new Object[]{this.getMaximumCount(), new TranslationTextComponent(block.func_149739_a()), count});
    }

    @ConstructorProperties(value={"maximumCount"})
    public MaximumBlockCountValidator(int maximumCount) {
        this.maximumCount = maximumCount;
    }

    public int getMaximumCount() {
        return this.maximumCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaximumBlockCountValidator)) {
            return false;
        }
        MaximumBlockCountValidator other = (MaximumBlockCountValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMaximumCount() == other.getMaximumCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaximumBlockCountValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaximumCount();
        return result;
    }

    public String toString() {
        return "MaximumBlockCountValidator(maximumCount=" + this.getMaximumCount() + ")";
    }
}

