/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;

public class Tank
extends FluidTank
implements IFluidHandlerCapacity,
IFluidHandlerMutable {
    public Tank(int capacity) {
        super(capacity);
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty() || this.getFluid().getAmount() <= 0;
    }

    public boolean isFull() {
        return !this.getFluid().isEmpty() && this.getFluid().getAmount() >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return !this.getFluid().isEmpty() ? this.getFluid().getFluid() : null;
    }

    protected boolean replaceInnerFluid() {
        return true;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.replaceInnerFluid()) {
            super.writeToNBT(nbt);
        }
        this.writeTankToNBT(nbt);
        return nbt;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt, String tag) {
        CompoundNBT subTag = new CompoundNBT();
        this.writeToNBT(subTag);
        nbt.func_218657_a(tag, (INBT)subTag);
        return nbt;
    }

    public FluidTank readFromNBT(CompoundNBT nbt) {
        if (this.replaceInnerFluid()) {
            if (nbt.func_74764_b("Empty")) {
                this.setFluid(null);
            }
            super.readFromNBT(nbt);
        }
        this.readTankFromNBT(nbt);
        return this;
    }

    public FluidTank readFromNBT(CompoundNBT data, String tag) {
        CompoundNBT subTag = data.func_74775_l(tag);
        return this.readFromNBT(subTag);
    }

    public void writeTankToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("capacity", this.getCapacity());
    }

    public void readTankFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("capacity")) {
            this.setCapacity(nbt.func_74762_e("capacity"));
        }
    }

    @Override
    public void setFluidInTank(int tank, FluidStack fluidStack) {
        if (tank == 0) {
            this.setFluid(fluidStack);
        }
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        if (tank == 0) {
            this.setCapacity(capacity);
        }
    }

    @Override
    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.getCapacity();
        }
        return 0;
    }
}

