/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;

public final class ItemStackHelpers {
    private static final Random RANDOM = new Random();

    public static void spawnItemStack(World world, BlockPos pos, ItemStack itemStack) {
        ItemStackHelpers.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), itemStack);
    }

    public static void spawnItemStack(World world, double x, double y, double z, ItemStack itemStack) {
        float offsetX = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetZ = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (itemStack.func_190916_E() > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > itemStack.func_190916_E()) {
                i = itemStack.func_190916_E();
            }
            ItemStack dropStack = itemStack.func_77946_l();
            itemStack.func_190918_g(i);
            dropStack.func_190920_e(i);
            ItemEntity entityitem = new ItemEntity(world, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, dropStack);
            float motion = 0.05f;
            entityitem.func_213293_j(RANDOM.nextGaussian() * (double)motion, RANDOM.nextGaussian() * (double)motion + 0.2, RANDOM.nextGaussian() * (double)motion);
            world.func_217376_c((Entity)entityitem);
        }
    }

    public static void spawnItemStackToPlayer(World world, BlockPos pos, ItemStack stack, PlayerEntity player) {
        if (!world.func_201670_d()) {
            float f = 0.5f;
            double xo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double yo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double zo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity entityitem = new ItemEntity(world, (double)pos.func_177958_n() + xo, (double)pos.func_177956_o() + yo, (double)pos.func_177952_p() + zo, stack);
            double d0 = 8.0;
            double d1 = (player.func_226277_ct_() - entityitem.func_226277_ct_()) / d0;
            double d2 = (player.func_226278_cu_() + (double)player.func_70047_e() - entityitem.func_226278_cu_()) / d0;
            double d3 = (player.func_226281_cx_() - entityitem.func_226281_cx_()) / d0;
            entityitem.func_213317_d(entityitem.func_213322_ci().func_72441_c(d1, d2, d3));
            entityitem.func_174868_q();
            world.func_217376_c((Entity)entityitem);
        }
    }

    public static boolean hasPlayerItem(PlayerEntity player, Item item) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack == null || itemStack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack parseItemStack(String itemStackString) {
        String[] split = itemStackString.split(":");
        String itemName = split[0] + ":" + split[1];
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new IllegalArgumentException("Invalid ItemStack item: " + itemName);
        }
        int amount = 1;
        if (split.length > 2) {
            try {
                amount = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid ItemStack amount: " + split[2]);
            }
        }
        return new ItemStack((IItemProvider)item, amount);
    }

    public static int getItemStackHashCode(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a.hashCode();
        }
        int result = 1;
        result = 37 * result + stack.func_190916_E();
        result = 37 * result + stack.func_77973_b().hashCode();
        return result;
    }

    public static boolean isValidCreativeTab(Item item, @Nullable ItemGroup itemGroup) {
        for (ItemGroup itemTab : item.getCreativeTabs()) {
            if (itemTab != itemGroup) continue;
            return true;
        }
        return itemGroup == null || itemGroup == ItemGroup.field_78027_g;
    }
}

