/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class LocationHelpers {
    private static final Random random = new Random();

    public static PacketDistributor.TargetPoint createTargetPointFromEntity(Entity entity, int range) {
        return new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (double)range, entity.field_70170_p.func_234923_W_());
    }

    public static PacketDistributor.TargetPoint createTargetPointFromLocation(World world, BlockPos location, int range) {
        return new PacketDistributor.TargetPoint((double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p(), (double)range, world.func_234923_W_());
    }

    public static BlockPos getRandomPointInSphere(BlockPos center, int radius) {
        BlockPos randomPoint = null;
        while (randomPoint == null) {
            BlockPos coordinates = center.func_177982_a(-radius + random.nextInt(2 * radius), -radius + random.nextInt(2 * radius), -radius + random.nextInt(2 * radius));
            double totalDistance = center.func_177951_i((Vector3i)coordinates);
            if ((int)Math.sqrt(totalDistance) > radius) continue;
            randomPoint = coordinates;
        }
        return randomPoint;
    }

    public static BlockPos copyLocation(BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static Vector3i copyLocation(Vector3i blockPos) {
        return new Vector3i(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static BlockPos addToDimension(BlockPos blockPos, int dimension, int value) {
        if (dimension == 0) {
            return blockPos.func_177982_a(value, 0, 0);
        }
        if (dimension == 1) {
            return blockPos.func_177982_a(0, value, 0);
        }
        if (dimension == 2) {
            return blockPos.func_177982_a(0, 0, value);
        }
        return blockPos;
    }

    public static BlockPos fromArray(int[] coordinates) {
        return new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
    }

    public static int[] toArray(Vector3i blockPos) {
        return new int[]{blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()};
    }

    public static BlockPos subtract(BlockPos blockPos, Vector3i vec) {
        return new BlockPos(blockPos.func_177958_n() - vec.func_177958_n(), blockPos.func_177956_o() - vec.func_177956_o(), blockPos.func_177952_p() - vec.func_177952_p());
    }

    public static Vector3i subtract(Vector3i vec1, Vector3i vec2) {
        return new Vector3i(vec1.func_177958_n() - vec2.func_177958_n(), vec1.func_177956_o() - vec2.func_177956_o(), vec1.func_177952_p() - vec2.func_177952_p());
    }

    public static double getYaw(BlockPos start, BlockPos end) {
        double dX = start.func_177958_n() - end.func_177958_n();
        double dY = start.func_177956_o() - end.func_177956_o();
        double dZ = start.func_177952_p() - end.func_177952_p();
        return Math.atan2(dZ, dX) * 180.0 / Math.PI;
    }

    public static double getPitch(BlockPos start, BlockPos end) {
        double dX = start.func_177958_n() - end.func_177958_n();
        double dY = start.func_177956_o() - end.func_177956_o();
        double dZ = start.func_177952_p() - end.func_177952_p();
        return (Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI) * 180.0 / Math.PI;
    }

    public static String toCompactString(BlockPos pos) {
        return String.format("x: %s ; y: %s ;z: %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static String toCompactString(Vector3i vec) {
        return String.format("%sx%sx%s", vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }
}

