/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class SimpleInventory
implements INBTInventory,
ISidedInventory {
    protected final ItemStack[] contents;
    private final int stackLimit;
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();
    private int hash;

    public SimpleInventory() {
        this(0, 0);
    }

    public SimpleInventory(int size, int stackLimit) {
        this.contents = new ItemStack[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = ItemStack.field_190927_a;
        }
        this.stackLimit = stackLimit;
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int func_70302_i_() {
        return this.contents.length;
    }

    public ItemStack func_70301_a(int slotId) {
        return this.contents[slotId];
    }

    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack stack = this.func_70301_a(slotId);
        if (slotId < this.func_70302_i_() && !stack.func_190926_b()) {
            if (stack.func_190916_E() > count) {
                ItemStack slotContents = stack.func_77946_l();
                ItemStack result = slotContents.func_77979_a(count);
                this.func_70299_a(slotId, slotContents);
                return result;
            }
            this.func_70299_a(slotId, ItemStack.field_190927_a);
            this.onInventoryChanged();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        if (slotId >= this.func_70302_i_()) {
            return;
        }
        this.contents[slotId] = Objects.requireNonNull(itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.onInventoryChanged();
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    protected void onInventoryChanged() {
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity entityplayer) {
        return true;
    }

    public void func_174889_b(PlayerEntity playerIn) {
    }

    public void func_174886_c(PlayerEntity playerIn) {
    }

    @Override
    public void read(CompoundNBT data) {
        this.readFromNBT(data, "items");
    }

    public void readFromNBT(CompoundNBT data, String tag) {
        int j;
        ListNBT nbttaglist = data.func_150295_c(tag, 10);
        for (j = 0; j < this.func_70302_i_(); ++j) {
            this.contents[j] = ItemStack.field_190927_a;
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            CompoundNBT slot = nbttaglist.func_150305_b(j);
            int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
            if (index < 0 || index >= this.func_70302_i_()) continue;
            this.contents[index] = ItemStack.func_199557_a((CompoundNBT)slot);
        }
    }

    @Override
    public void write(CompoundNBT data) {
        this.writeToNBT(data, "items");
    }

    public void writeToNBT(CompoundNBT data, String tag) {
        ListNBT slots = new ListNBT();
        for (byte index = 0; index < this.func_70302_i_(); index = (byte)((byte)(index + 1))) {
            ItemStack itemStack = this.func_70301_a(index);
            if (itemStack.func_190926_b() || itemStack.func_190916_E() <= 0) continue;
            CompoundNBT slot = new CompoundNBT();
            slots.add((Object)slot);
            slot.func_74774_a("Slot", index);
            itemStack.func_77955_b(slot);
        }
        data.func_218657_a(tag, (INBT)slots);
    }

    public ItemStack func_70304_b(int slotId) {
        ItemStack stackToTake = this.func_70301_a(slotId);
        if (stackToTake.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70299_a(slotId, ItemStack.field_190927_a);
        return stackToTake;
    }

    public ItemStack[] getItemStacks() {
        return this.contents;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i < this.func_70302_i_() && i >= 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.contents[i] = ItemStack.field_190927_a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70296_d() {
        LinkedList dirtyMarkListeners;
        ++this.hash;
        SimpleInventory simpleInventory = this;
        synchronized (simpleInventory) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    @Override
    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        this.write(tag);
        return tag;
    }

    @Override
    public void fromNBT(CompoundNBT tag) {
        this.read(tag);
    }

    public IItemHandler getItemHandler() {
        return new InvWrapper((IInventory)this);
    }

    public IItemHandler getItemHandlerSided(Direction side) {
        return new SidedInvWrapper((ISidedInventory)this, side);
    }

    public int getState() {
        return this.hash;
    }

    public int[] func_180463_a(Direction side) {
        return IntStream.range(0, this.func_70302_i_()).toArray();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }
}

