/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.registry.Registry;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;

public abstract class RegistryExportableRecipeAbstract<T extends IRecipeType<? extends R>, R extends IRecipe<C>, C extends IInventory>
implements IRegistryExportable {
    private final Supplier<T> recipeType;

    protected RegistryExportableRecipeAbstract(Supplier<T> recipeType) {
        this.recipeType = recipeType;
    }

    public T getRecipeType() {
        return (T)((IRecipeType)this.recipeType.get());
    }

    @Override
    public JsonObject export() {
        JsonObject element = new JsonObject();
        JsonArray elements = new JsonArray();
        element.add("recipes", (JsonElement)elements);
        for (IRecipe recipe : CraftingHelpers.findServerRecipes(this.getRecipeType())) {
            JsonObject serializedRecipe = this.serializeRecipe(recipe);
            serializedRecipe.addProperty("id", recipe.func_199560_c().toString());
            elements.add((JsonElement)serializedRecipe);
        }
        return element;
    }

    @Override
    public String getName() {
        return Registry.field_218367_H.func_177774_c(this.getRecipeType()).toString().replaceAll(":", "__");
    }

    public abstract JsonObject serializeRecipe(R var1);
}

