/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.IRegistryExportableRegistry;

public class RegistryExportableRegistry
implements IRegistryExportableRegistry {
    public static final RegistryExportableRegistry INSTANCE = new RegistryExportableRegistry();
    private final List<IRegistryExportable> exportables = Lists.newArrayList();

    private RegistryExportableRegistry() {
    }

    public static RegistryExportableRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void register(IRegistryExportable exportable) {
        this.exportables.add(exportable);
    }

    @Override
    public List<IRegistryExportable> getExportables() {
        return this.exportables;
    }

    @Override
    public void export(Path basePath) throws IOException {
        basePath.toFile().mkdirs();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (IRegistryExportable exportable : this.exportables) {
            String fileName = exportable.getName() + ".json";
            JsonObject data = exportable.export();
            FileUtils.writeStringToFile((File)basePath.resolve(fileName).toFile(), (String)gson.toJson((JsonElement)data), (Charset)Charsets.UTF_8);
        }
    }
}

