/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.jei;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import org.cyclops.cyclopscore.helper.CraftingHelpers;

public abstract class RecipeRegistryJeiRecipeWrapper<C extends IInventory, R extends IRecipe<C>, J extends RecipeRegistryJeiRecipeWrapper<C, R, J>> {
    private static final Map<IRecipe<?>, RecipeRegistryJeiRecipeWrapper<?, ?, ?>> RECIPE_WRAPPERS = Maps.newIdentityHashMap();
    protected final R recipe;

    protected RecipeRegistryJeiRecipeWrapper(IRecipeType<R> recipeType, R recipe) {
        this.recipe = recipe;
    }

    public R getRecipe() {
        return this.recipe;
    }

    protected abstract IRecipeType<R> getRecipeType();

    protected abstract J newInstance(R var1);

    public static <T extends IRecipeType<R>, C extends IInventory, R extends IRecipe<C>, J extends RecipeRegistryJeiRecipeWrapper<C, R, J>> T getJeiRecipeWrapper(R input) {
        return (T)((IRecipeType)RECIPE_WRAPPERS.get(input));
    }

    public Collection<J> createAllRecipes() {
        return Collections2.transform(CraftingHelpers.getClientRecipes(this.getRecipeType()), (Function)new Function<R, J>(){

            @Nullable
            public J apply(R input) {
                if (!RECIPE_WRAPPERS.containsKey(input)) {
                    RECIPE_WRAPPERS.put(input, RecipeRegistryJeiRecipeWrapper.this.newInstance(input));
                }
                return (RecipeRegistryJeiRecipeWrapper)RECIPE_WRAPPERS.get(input);
            }
        });
    }
}

