/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.mob;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.drop.LootDrop;
import jeresources.config.Settings;
import jeresources.entry.MobEntry;
import jeresources.util.CollectionHelper;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class MobWrapper
implements IRecipeCategoryExtension,
ITooltipCallback<ItemStack> {
    private final MobEntry mob;
    private float scale;
    private int offsetY;

    public MobWrapper(MobEntry mob) {
        this.mob = mob;
        this.scale = this.getScale(mob.getEntity());
        this.offsetY = this.getOffsetY(mob.getEntity());
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, this.mob.getDropsItemStacks());
    }

    public LootDrop[] getDrops() {
        return this.mob.getDrops();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, MatrixStack matrixStack, double mouseX, double mouseY) {
        String entityString;
        LivingEntity LivingEntity2 = this.mob.getEntity();
        RenderHelper.scissor(matrixStack, 7, 43, 59, 79);
        this.scale = this.getScale(this.mob.getEntity());
        this.offsetY = this.getOffsetY(this.mob.getEntity());
        RenderHelper.renderEntity(matrixStack, 37, 105 - this.offsetY, this.scale, 38.0 - mouseX, (double)(70 - this.offsetY) - mouseY, LivingEntity2);
        RenderHelper.stopScissor();
        String mobName = this.mob.getMobName();
        if (Settings.showDevData && (entityString = LivingEntity2.func_70022_Q()) != null) {
            mobName = mobName + " (" + entityString + ")";
        }
        Font.normal.print(matrixStack, mobName, 7, 2);
        Font.normal.print(matrixStack, this.mob.getBiomes().length > 1 ? TranslationHelper.translateAndFormat("jer.mob.biome", new Object[0]) : TranslationHelper.translateAndFormat("jer.mob.spawn", new Object[0]) + " " + this.mob.getBiomes()[0], 7, 12);
        Font.normal.print(matrixStack, this.mob.getLightLevel(), 7, 22);
        Font.normal.print(matrixStack, TranslationHelper.translateAndFormat("jer.mob.exp", new Object[0]) + ": " + this.mob.getExp(), 7, 32);
    }

    public List<ITextComponent> getTooltipStrings(double mouseX, double mouseY) {
        if (this.mob.getBiomes().length > 1 && this.isOnBiome(mouseX, mouseY)) {
            return CollectionHelper.create(StringTextComponent::new, this.mob.getBiomes());
        }
        return Collections.emptyList();
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)this.mob.getDrops()[slotIndex].toStringTextComponent());
        List<ITextComponent> list = this.getToolTip(ingredient);
        if (list != null) {
            tooltip.addAll(list);
        }
    }

    public LivingEntity getMob() {
        return this.mob.getEntity();
    }

    public List<ITextComponent> getToolTip(ItemStack stack) {
        for (LootDrop item : this.mob.getDrops()) {
            if (stack.func_77969_a(item.item)) {
                return item.getTooltipText();
            }
            if (!item.canBeCooked() || !stack.func_77969_a(item.smeltedItem)) continue;
            return item.getTooltipText(true);
        }
        return null;
    }

    private boolean isOnBiome(double mouseX, double mouseY) {
        return 2.0 <= mouseX && mouseX < 165.0 && 12.0 <= mouseY && mouseY < 22.0;
    }

    private float getScale(LivingEntity LivingEntity2) {
        float height;
        float width = LivingEntity2.func_213311_cf();
        if (width <= (height = LivingEntity2.func_213302_cg())) {
            if ((double)height < 0.9) {
                return 50.0f;
            }
            if (height < 1.0f) {
                return 35.0f;
            }
            if ((double)height < 1.8) {
                return 33.0f;
            }
            if (height < 2.0f) {
                return 32.0f;
            }
            if (height < 3.0f) {
                return 24.0f;
            }
            if (height < 4.0f) {
                return 20.0f;
            }
            return 10.0f;
        }
        if (width < 1.0f) {
            return 38.0f;
        }
        if (width < 2.0f) {
            return 27.0f;
        }
        if (width < 3.0f) {
            return 13.0f;
        }
        return 9.0f;
    }

    private int getOffsetY(LivingEntity livingEntity) {
        int offsetY = 0;
        if (livingEntity instanceof SquidEntity) {
            offsetY = 20;
        } else if (livingEntity instanceof TurtleEntity) {
            offsetY = 10;
        } else if (livingEntity instanceof WitchEntity) {
            offsetY = -5;
        } else if (livingEntity instanceof GhastEntity) {
            offsetY = 15;
        } else if (livingEntity instanceof WitherEntity) {
            offsetY = -15;
        } else if (livingEntity instanceof EnderDragonEntity) {
            offsetY = 15;
        } else if (livingEntity instanceof EndermanEntity) {
            offsetY = -10;
        } else if (livingEntity instanceof GolemEntity) {
            offsetY = -10;
        } else if (livingEntity instanceof AnimalEntity) {
            offsetY = -20;
        } else if (livingEntity instanceof VillagerEntity) {
            offsetY = -15;
        } else if (livingEntity instanceof WanderingTraderEntity) {
            offsetY = -15;
        } else if (livingEntity instanceof BlazeEntity) {
            offsetY = -10;
        } else if (livingEntity instanceof CreeperEntity) {
            offsetY = -15;
        }
        return offsetY;
    }
}

