/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import com.google.common.base.Objects;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.Conditional;
import jeresources.api.drop.LootDrop;
import jeresources.config.Settings;
import jeresources.entry.WorldGenEntry;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGenWrapper
implements IRecipeCategoryExtension,
ITooltipCallback<ItemStack> {
    protected static final int X_OFFSET = 29;
    protected static final int Y_OFFSET = 52;
    protected static final int X_AXIS_SIZE = 128;
    protected static final int Y_AXIS_SIZE = 40;
    private final WorldGenEntry worldGenEntry;

    public WorldGenWrapper(WorldGenEntry worldGenEntry) {
        this.worldGenEntry = worldGenEntry;
    }

    public int getLineColor() {
        return this.worldGenEntry.getColour();
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.worldGenEntry.getBlock());
        ingredients.setOutputs(VanillaTypes.ITEM, this.worldGenEntry.getBlockAndDrops());
    }

    public ItemStack getBlock() {
        return this.worldGenEntry.getBlock();
    }

    public List<ItemStack> getDrops() {
        return this.worldGenEntry.getDrops();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, MatrixStack matrixStack, double mouseX, double mouseY) {
        float[] array = this.worldGenEntry.getChances();
        double max = 0.0;
        float[] fArray = array;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double d = fArray[i];
            if (!(d > max)) continue;
            max = d;
        }
        double xPrev = 29.0;
        double yPrev = 52.0;
        double space = 128.0 / ((double)(array.length - 1) * 1.0);
        for (int i = 0; i < array.length; ++i) {
            double value = array[i];
            double y = 52.0 - value / max * 40.0;
            if (i > 0) {
                double x = xPrev + space;
                RenderHelper.drawLine(matrixStack, xPrev, yPrev, x, y, this.getLineColor());
                xPrev = x;
            }
            yPrev = y;
        }
        int xPercents = 27;
        int yPercents = 48;
        String minPercent = "0%";
        int minPercentWidth = Font.small.getStringWidth("0%");
        Font.small.print(matrixStack, "0%", 27 - minPercentWidth, 48);
        String maxPercent = String.format("%.2f", max * 100.0) + "%";
        int maxPercentWidth = Font.small.getStringWidth(maxPercent);
        Font.small.print(matrixStack, maxPercent, 27 - maxPercentWidth, 8);
        int yLabels = 54;
        int xLabels = 29;
        int minLabel = this.worldGenEntry.getMinY();
        int minLabelWidth = Font.small.getStringWidth(String.valueOf(minLabel));
        int minLabelOffset = 29 - minLabelWidth / 2;
        Font.small.print(matrixStack, minLabel, minLabelOffset, 54);
        int maxLabel = this.worldGenEntry.getMaxY();
        int maxLabelWidth = Font.small.getStringWidth(String.valueOf(maxLabel));
        int maxLabelOffset = 157 - maxLabelWidth / 2;
        Font.small.print(matrixStack, maxLabel, maxLabelOffset, 54);
        int midLabel = (maxLabel + minLabel) / 2;
        int midLabelWidth = Font.small.getStringWidth(String.valueOf(midLabel));
        int midLabelOffset = 93 - midLabelWidth / 2;
        Font.small.print(matrixStack, midLabel, midLabelOffset, 54);
        Font.small.print(matrixStack, TranslationHelper.translateAndFormat("jer.worldgen.drops", new Object[0]), 5, 58);
        String dimension = TranslationHelper.tryDimensionTranslate(this.worldGenEntry.getDimension());
        int x = (recipeWidth - Font.normal.getStringWidth(dimension)) / 2;
        Font.normal.print(matrixStack, dimension, x, 0);
    }

    public List<ITextComponent> getTooltipStrings(double mouseX, double mouseY) {
        List<ITextComponent> tooltip = new LinkedList<ITextComponent>();
        if (this.onGraph(mouseX, mouseY)) {
            tooltip = this.getLineTooltip(mouseX, tooltip);
        }
        return tooltip;
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
        tooltip.addAll(this.getItemStackTooltip(slotIndex, ingredient));
    }

    private List<ITextComponent> getItemStackTooltip(int slot, ItemStack itemStack) {
        LinkedList<String> tooltip = new LinkedList<String>();
        if (itemStack != null && slot == 0) {
            List<String> biomes;
            if (this.worldGenEntry.isSilkTouchNeeded()) {
                tooltip.add(Conditional.silkTouch.toString());
            }
            if ((biomes = this.worldGenEntry.getBiomeRestrictions()).size() > 0) {
                tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.biomes", new Object[0]) + ":");
                tooltip.addAll(biomes);
            }
            if (Settings.showDevData) {
                tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.averageChunk", new Object[0]) + ":");
                tooltip.add("" + this.worldGenEntry.getAverageBlockCountPerChunk());
            }
        } else {
            tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.average", new Object[0]));
            String previousChanceString = null;
            for (LootDrop dropItem : this.worldGenEntry.getLootDrops(itemStack)) {
                String chanceString = dropItem.chanceString();
                if (Objects.equal((Object)chanceString, previousChanceString)) continue;
                previousChanceString = chanceString;
                String line = "  ";
                line = dropItem.fortuneLevel > 0 ? line + ((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("minecraft.fortune"))).func_200305_d(dropItem.fortuneLevel).toString() : line + TranslationHelper.translateAndFormat("jer.worldgen.base", new Object[0]);
                line = line + ": " + chanceString;
                tooltip.add(line);
            }
        }
        return tooltip.stream().map(StringTextComponent::new).collect(Collectors.toList());
    }

    private List<ITextComponent> getLineTooltip(double mouseX, List<ITextComponent> tooltip) {
        double exactMouseX = WorldGenWrapper.getExactMouseX(mouseX);
        float[] chances = this.worldGenEntry.getChances();
        double space = 128.0 / ((double)chances.length * 1.0);
        int index = (int)((exactMouseX - 29.0 + 1.0) / space);
        int yValue = index + this.worldGenEntry.getMinY();
        if (index >= 0 && index < chances.length) {
            float chance = chances[index] * 100.0f;
            String percent = chance > 0.01f || chance == 0.0f ? String.format(" (%.2f%%)", Float.valueOf(chance)) : " <0.01%";
            tooltip.add((ITextComponent)new StringTextComponent("Y: " + yValue + percent));
        }
        return tooltip;
    }

    private static double getExactMouseX(double mouseX) {
        Minecraft mc = Minecraft.func_71410_x();
        int scaledWidth = mc.func_228018_at_().func_198107_o();
        double mouseXExact = mc.field_71417_B.func_198024_e() * (double)scaledWidth / (double)mc.func_228018_at_().func_198105_m();
        double mouseXFraction = mouseXExact - Math.floor(mouseXExact);
        return mouseX + mouseXFraction;
    }

    private boolean onGraph(double mouseX, double mouseY) {
        return mouseX >= 28.0 && mouseX < 157.0 && mouseY >= 11.0 && mouseY < 52.0;
    }
}

