/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.collections;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;

public class WeightedList<T> {
    private final List<Node<T>> items = Lists.newArrayList();
    private int totalWeight = 0;

    public void add(T value, int weight) {
        if (weight < 0) {
            throw new IllegalArgumentException("Weight must be positive!");
        }
        if (weight == 0) {
            return;
        }
        this.items.add(new Node(value, weight));
        this.totalWeight += weight;
    }

    public boolean remove(T value) {
        for (Node<T> item : this.items) {
            if (!item.value.equals(value)) continue;
            this.items.remove(item);
            this.totalWeight -= item.weight;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.totalWeight == 0;
    }

    public T getRandomItem(Random random) {
        if (this.isEmpty()) {
            return null;
        }
        int i = random.nextInt(this.totalWeight);
        for (Node<T> item : this.items) {
            if (i < item.weight) {
                return item.value;
            }
            i -= item.weight;
        }
        throw new AssertionError((Object)"Method didn't return a value!");
    }

    private static class Node<T> {
        protected final T value;
        protected final int weight;

        private Node(T value, int weight) {
            this.value = value;
            this.weight = weight;
        }
    }
}

