/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.config;

import azmalent.cuneiform.lib.config.AbstractConfigObject;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public abstract class AbstractConfigFile
extends AbstractConfigObject {
    protected final String modid;
    protected final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    protected ForgeConfigSpec spec;

    protected AbstractConfigFile(String modid) {
        this.modid = modid;
    }

    protected abstract ModConfig.Type getConfigType();

    protected abstract String getConfigFilename();

    protected final ForgeConfigSpec getSpec() {
        if (this.spec == null) {
            this.spec = this.builder.build();
        }
        return this.spec;
    }

    protected void build() {
        this.initFields(this.builder);
        this.initSubCategories(this.builder);
    }

    public void register() {
        this.build();
        this.sync();
        ModLoadingContext.get().registerConfig(this.getConfigType(), this.getSpec(), this.getConfigFilename());
        this.postInit();
    }

    public void sync() {
        String filename = this.getConfigFilename();
        Path configPath = FMLPaths.CONFIGDIR.get().resolve(filename);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        this.getSpec().setConfig((CommentedConfig)configData);
    }
}

