/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.config;

import azmalent.cuneiform.lib.config.Category;
import azmalent.cuneiform.lib.config.data.ConfigFlagManager;
import azmalent.cuneiform.lib.config.options.AbstractConfigOption;
import azmalent.cuneiform.lib.config.options.BooleanOption;
import azmalent.cuneiform.lib.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractConfigObject {
    protected final void initFields(ForgeConfigSpec.Builder builder) {
        Class<?> clazz = this.getClass();
        AbstractConfigObject instance = (AbstractConfigObject)ReflectionUtil.getSingletonInstance(this.getClass());
        for (Field field : clazz.getFields()) {
            try {
                if (!AbstractConfigOption.class.isAssignableFrom(field.getType())) continue;
                AbstractConfigOption option = (AbstractConfigOption)field.get(instance);
                option.init(builder, field);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public void initSubCategories(ForgeConfigSpec.Builder builder) {
        for (Class<?> innerClass : this.getClass().getDeclaredClasses()) {
            if (!Category.class.isAssignableFrom(innerClass)) continue;
            try {
                Category category = innerClass.asSubclass(Category.class).newInstance();
                category.init(builder);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    protected void postInit() {
    }

    protected void initFlags(String modid) {
        Class<?> clazz = this.getClass();
        AbstractConfigObject instance = (AbstractConfigObject)ReflectionUtil.getSingletonInstance(this.getClass());
        for (Field field : clazz.getFields()) {
            try {
                BooleanOption option;
                if (!BooleanOption.class.isAssignableFrom(field.getType()) || !(option = (BooleanOption)field.get(instance)).hasFlag()) continue;
                ConfigFlagManager.putFlag(modid, option.getFlag(), option.get());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredClasses()) {
            if (!Category.class.isAssignableFrom((Class<?>)annotatedElement)) continue;
            try {
                Category category = ((Class)annotatedElement).asSubclass(Category.class).newInstance();
                category.initFlags(modid);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }
}

