/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.config.options;

import azmalent.cuneiform.lib.config.options.AbstractConfigOption;
import azmalent.cuneiform.lib.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public final class DoubleOption
extends AbstractConfigOption<Double, Double> {
    protected ForgeConfigSpec.ConfigValue<Double> value;
    protected double defaultValue;
    private boolean rangeRestricted = false;
    private double min;
    private double max;
    private List<Double> allowedValues;

    public DoubleOption(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Double get() {
        return (Double)this.value.get();
    }

    @Override
    public void set(Double newValue) {
        this.value.set((Object)newValue);
    }

    public DoubleOption inUnitRange() {
        return this.inRange(0.0, 1.0);
    }

    public DoubleOption inRange(double min, double max) {
        this.rangeRestricted = true;
        this.min = min;
        this.max = max;
        return this;
    }

    public DoubleOption withAllowedValues(double ... allowedValues) {
        this.allowedValues = Arrays.stream(allowedValues).boxed().collect(Collectors.toList());
        return this;
    }

    @Override
    public void init(ForgeConfigSpec.Builder builder, Field field) {
        this.value = this.rangeRestricted ? this.addComment(builder, field, "Default: " + this.defaultValue).defineInRange(this.getName(field), this.defaultValue, this.min, this.max) : (this.allowedValues != null ? this.addComment(builder, field, "Default: " + this.defaultValue, "Allowed values: [" + StringUtil.joinObjects(", ", this.allowedValues) + "]").defineInList(this.getName(field), (Object)this.defaultValue, this.allowedValues) : this.addComment(builder, field, "Default: " + this.defaultValue).define(this.getName(field), (Object)this.defaultValue));
    }

    public float getAsFloat() {
        return (float)this.get().doubleValue();
    }
}

