/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.config.options.lazy;

import azmalent.cuneiform.lib.config.options.AbstractConfigOption;
import azmalent.cuneiform.lib.config.options.lazy.ILazyOption;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public class LazyListOption<T>
extends AbstractConfigOption<List<T>, List<? extends String>>
implements ILazyOption {
    protected ForgeConfigSpec.ConfigValue<List<? extends String>> stringValues;
    private final List<String> defaultValue;
    protected final Function<String, T> constructor;
    protected List<T> value;
    private boolean initialized = false;

    protected LazyListOption(List<String> defaultValue) {
        this.defaultValue = defaultValue;
        this.constructor = null;
    }

    public LazyListOption(Function<String, T> constructor) {
        this(Lists.newArrayList(), constructor);
    }

    public LazyListOption(List<String> defaultValue, Function<String, T> constructor) {
        this.defaultValue = defaultValue;
        this.constructor = constructor;
    }

    @Override
    public List<T> get() {
        if (!this.initialized) {
            this.initValue();
        }
        return this.value;
    }

    @Override
    public void set(List<? extends String> newValue) {
        this.stringValues.set(newValue);
        this.invalidate();
    }

    @Override
    public void init(ForgeConfigSpec.Builder builder, Field field) {
        this.stringValues = this.addComment(builder, field, "Default: " + this.defaultValue).defineList(this.getName(field), this.defaultValue, Objects::nonNull);
    }

    @Override
    public void invalidate() {
        this.value = null;
        this.initialized = false;
    }

    @Override
    public void initValue() {
        this.initialized = true;
        this.value = ((List)this.stringValues.get()).stream().map(this.constructor).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

