/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.blocks;

import com.naterbobber.darkerdepths.core.registries.DDBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HeartChamberBlock
extends Block {
    public static final IntegerProperty CHARGES = BlockStateProperties.field_235912_aC_;

    public HeartChamberBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CHARGES, (Comparable)Integer.valueOf(0)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        if (handIn == Hand.MAIN_HAND && !HeartChamberBlock.isValidFuel(stack) && HeartChamberBlock.isValidFuel(player.func_184586_b(Hand.OFF_HAND))) {
            return ActionResultType.PASS;
        }
        if (HeartChamberBlock.isValidFuel(stack) && HeartChamberBlock.notFullyCharged(state)) {
            HeartChamberBlock.chargeChamber(worldIn, pos, state);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if ((Integer)state.func_177229_b((Property)CHARGES) == 0) {
            return ActionResultType.PASS;
        }
        return HeartChamberBlock.notFullyCharged(state) ? ActionResultType.PASS : ActionResultType.CONSUME;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (int)Math.floor((float)((Integer)state.func_177229_b((Property)CHARGES)).intValue() / 4.0f * 15.0f);
    }

    private static boolean isValidFuel(ItemStack stack) {
        return stack.func_77973_b().equals(((Block)DDBlocks.AMBER.get()).func_199767_j());
    }

    private static boolean notFullyCharged(BlockState state) {
        return (Integer)state.func_177229_b((Property)CHARGES) < 4;
    }

    public static void chargeChamber(World worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CHARGES, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)CHARGES) + 1)), 3);
        worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CHARGES});
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public static int getChargeScale(BlockState state, int scale) {
        return MathHelper.func_76141_d((float)((float)((Integer)state.func_177229_b((Property)CHARGES)).intValue() / 4.0f * (float)scale));
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return HeartChamberBlock.getChargeScale(blockState, 15);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

