/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.tileentities;

import java.util.List;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class HeartChamberTileEntity
extends TileEntity
implements ITickableTileEntity {
    private List<LivingEntity> entitiesInRange;
    private boolean shouldHeal;
    private int healWarmup;

    public HeartChamberTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        if (this.shouldHeal) {
            if (this.healWarmup < 40) {
                ++this.healWarmup;
            } else {
                this.healEntities(this.field_145850_b);
                this.addHealingParticles(this.field_145850_b);
                this.shouldHeal = false;
            }
        }
    }

    private void healEntities(World worldIn) {
        if (!worldIn.field_72995_K) {
            this.entitiesInRange.stream().filter(this::isNearbyHealableEntities).forEach(this::heal);
        }
    }

    private void addHealingParticles(World worldIn) {
        if (worldIn.field_72995_K) {
            BlockPos pos = this.func_174877_v();
            MutableInt mutableInt = new MutableInt(16700985);
            int entitiesInRange = (int)this.entitiesInRange.stream().filter(entities -> pos.func_218137_a((IPosition)entities.func_213303_ch(), 32.0)).count();
            this.entitiesInRange.stream().filter(this::isNearbyHealableEntities).forEach(p_235655_4_ -> {
                float range = MathHelper.func_76133_a((double)((p_235655_4_.func_226277_ct_() - (double)pos.func_177958_n()) * (p_235655_4_.func_226277_ct_() - (double)pos.func_177958_n()) + (p_235655_4_.func_226281_cx_() - (double)pos.func_177952_p()) * (p_235655_4_.func_226281_cx_() - (double)pos.func_177952_p())));
                double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(1.0f / range) * (p_235655_4_.func_226277_ct_() - (double)pos.func_177958_n());
                double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(1.0f / range) * (p_235655_4_.func_226281_cx_() - (double)pos.func_177952_p());
                int index = MathHelper.func_76125_a((int)((entitiesInRange - 21) / -2), (int)3, (int)15);
                for (int i = 0; i < index; ++i) {
                    int color = mutableInt.addAndGet(5);
                    double red = (double)ColorHelper.PackedColor.func_233007_b_((int)color) / 255.0;
                    double green = (double)ColorHelper.PackedColor.func_233008_c_((int)color) / 255.0;
                    double blue = (double)ColorHelper.PackedColor.func_233009_d_((int)color) / 255.0;
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197625_r, x, (double)((float)pos.func_177956_o() + 0.5f), z, red, green, blue);
                }
            });
        }
    }

    private boolean isNearbyHealableEntities(LivingEntity entity) {
        return entity.func_70089_S() && !entity.field_70128_L && this.func_174877_v().func_218137_a((IPosition)entity.func_213303_ch(), 32.0) && entity.func_200600_R().equals(EntityType.field_200729_aH);
    }

    private void heal(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 6000));
    }
}

