/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen;

import com.blackgear.bgcore.core.registries.BGBiomes;
import com.naterbobber.darkerdepths.common.world.gen.VanillaBiomeFeatures;
import com.naterbobber.darkerdepths.core.registries.DDBiomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GlobalBiomeFeatures {
    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER || event.getCategory() == Biome.Category.THEEND) {
            return;
        }
        if (event.getName() != null) {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
            BiomeGenerationSettingsBuilder builder = event.getGeneration();
            if (biome == BGBiomes.DEFAULT_CAVE.get()) {
                VanillaBiomeFeatures.addCarvers((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addGlowshrooms((BiomeGenerationSettings.Builder)builder);
            }
            if (biome == DDBiomes.MOLTEN_CAVERN.get()) {
                VanillaBiomeFeatures.addAsh((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addAmber((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addMoltenCavernDecorations((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addCarvers((BiomeGenerationSettings.Builder)builder);
            }
            if (biome == DDBiomes.SANDY_CATACOMBS.get()) {
                VanillaBiomeFeatures.addSandyCatacombsTerrain((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addAridrockOres((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addLimestoneOres((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addSandyCatacombsVegetation((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addCarvers((BiomeGenerationSettings.Builder)builder);
            }
            if (biome == DDBiomes.CRYSTAL_CAVE.get()) {
                VanillaBiomeFeatures.addCarvers((BiomeGenerationSettings.Builder)builder);
                VanillaBiomeFeatures.addCrystalPeaks((BiomeGenerationSettings.Builder)builder);
            }
        }
    }
}

