/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.feature;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.common.world.gen.feature.BlobReplacementConfig;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class BlobReplacementFeature
extends Feature<BlobReplacementConfig> {
    public BlobReplacementFeature(Codec<BlobReplacementConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, BlobReplacementConfig config) {
        BlockPos distance;
        BlockPos position = BlobReplacementFeature.placeBlockOn((IWorld)worldIn, pos.func_239590_i_().func_239620_a_(Direction.Axis.Y, 1, worldIn.func_217301_I() - 1), config);
        if (position == null) {
            return false;
        }
        int radius = config.getRadius().func_242259_a(rand);
        boolean shouldPlace = false;
        Iterator iterator = BlockPos.func_239583_a_((BlockPos)position, (int)radius, (int)radius, (int)radius).iterator();
        while (iterator.hasNext() && (distance = (BlockPos)iterator.next()).func_218139_n((Vector3i)position) <= radius) {
            BlockState blockstate = worldIn.func_180495_p(distance);
            if (!config.target.contains(blockstate)) continue;
            this.func_230367_a_((IWorldWriter)worldIn, distance, config.blockState);
            shouldPlace = true;
        }
        return shouldPlace;
    }

    @Nullable
    private static BlockPos placeBlockOn(IWorld worldIn, BlockPos.Mutable pos, BlobReplacementConfig config) {
        while (pos.func_177956_o() > 1) {
            BlockState blockstate = worldIn.func_180495_p((BlockPos)pos);
            if (config.target.contains(blockstate)) {
                return pos;
            }
            pos.func_189536_c(Direction.DOWN);
        }
        return null;
    }
}

