/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.layer;

import com.naterbobber.darkerdepths.common.world.gen.layer.CaveBiomeLayer;
import java.util.function.LongFunction;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;

public class CaveLayerUtil {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> areaFactories(LongFunction<C> context) {
        IAreaFactory biomeFactory = CaveBiomeLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)context.apply(1000L));
        for (int caveBiomeSize = 0; caveBiomeSize <= 4; ++caveBiomeSize) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1000L + (long)caveBiomeSize), biomeFactory);
        }
        biomeFactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), biomeFactory);
        biomeFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), biomeFactory);
        return biomeFactory;
    }

    public static Layer createLayers(long seed) {
        return new Layer(CaveLayerUtil.areaFactories(salt -> new LazyAreaLayerContext(25, seed, salt)));
    }
}

