/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.placement;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.common.world.gen.placement.CaveDecoratorConfig;
import com.naterbobber.darkerdepths.core.util.CaveSurface;
import com.naterbobber.darkerdepths.core.util.Column;
import com.naterbobber.darkerdepths.core.util.helpers.BlockPosHelper;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;
import net.minecraft.world.gen.placement.Placement;

public class CaveSurfacePlacement
extends Placement<CaveDecoratorConfig> {
    public CaveSurfacePlacement(Codec<CaveDecoratorConfig> codec) {
        super(codec);
    }

    public Stream<BlockPos> getPositions(WorldDecoratingHelper worldIn, Random rand, CaveDecoratorConfig configIn, BlockPos pos) {
        Optional<Column> column = Column.scan((IWorldGenerationReader)worldIn.field_242889_a, pos, configIn.floorToCeilingSearchRange, AbstractBlock.AbstractBlockState::func_196958_f, state -> state.func_185904_a().func_76220_a());
        if (!column.isPresent()) {
            return Stream.of(new BlockPos[0]);
        }
        OptionalInt surfaceType = configIn.surface == CaveSurface.CEILING ? column.get().getCeiling() : column.get().getFloor();
        return !surfaceType.isPresent() ? Stream.of(new BlockPos[0]) : Stream.of(BlockPosHelper.atY(pos, surfaceType.getAsInt() - configIn.surface.getY()));
    }
}

