/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.core;

import com.naterbobber.darkerdepths.client.render.BlockRenderHandler;
import com.naterbobber.darkerdepths.common.entities.GlowshroomMonsterEntity;
import com.naterbobber.darkerdepths.common.entities.MagmaMinionEntity;
import com.naterbobber.darkerdepths.common.world.gen.GlobalBiomeFeatures;
import com.naterbobber.darkerdepths.core.CaveBiomeImplementation;
import com.naterbobber.darkerdepths.core.DDRegistryHelper;
import com.naterbobber.darkerdepths.core.init.EntityTypesInit;
import com.naterbobber.darkerdepths.core.registries.VanillaIntegrationRegistry;
import com.naterbobber.darkerdepths.core.util.DarkerDepthsItemGroup;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="darkerdepths")
@Mod.EventBusSubscriber(modid="darkerdepths", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DarkerDepths {
    public static DarkerDepths instance;
    public static final String MODID = "darkerdepths";
    public static final ItemGroup DARKER_DEPTHS;
    public static final DDRegistryHelper REGISTRY_HELPER;

    public DarkerDepths() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new GlobalBiomeFeatures());
        REGISTRY_HELPER.getItems().register(modEventBus);
        REGISTRY_HELPER.getBlocks().register(modEventBus);
        REGISTRY_HELPER.getCarvers().register(modEventBus);
        REGISTRY_HELPER.getFeatures().register(modEventBus);
        REGISTRY_HELPER.getBiomes().register(modEventBus);
        REGISTRY_HELPER.getPlacements().register(modEventBus);
        EntityTypesInit.ENTITY_TYPES.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypesInit.GLOWSHROOM_MONSTER.get()), (AttributeModifierMap)GlowshroomMonsterEntity.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypesInit.MAGMA_MINION.get()), (AttributeModifierMap)MagmaMinionEntity.setCustomAttributes().func_233813_a_());
        });
        VanillaIntegrationRegistry.setup();
        CaveBiomeImplementation.addCaveBiomes();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        BlockRenderHandler.blockRenders();
    }

    static {
        DARKER_DEPTHS = new DarkerDepthsItemGroup("DarkerDepths");
        REGISTRY_HELPER = new DDRegistryHelper(MODID);
    }
}

